/* global QUnit */

import { BatchedMesh } from '../../../../src/objects/BatchedMesh.js';
import { BoxGeometry } from '../../../../src/geometries/BoxGeometry.js';
import { MeshBasicMaterial } from '../../../../src/materials/MeshBasicMaterial.js';

export default QUnit.module( 'Objects', () => {

	QUnit.module( 'BatchedMesh', () => {

		// PUBLIC

		QUnit.test( 'setInstanceCount', ( assert ) => {

			const box = new BoxGeometry( 1, 1, 1 );
			const material = new MeshBasicMaterial( { color: 0x00ff00 } );
			
			// initialize and add a geometry into the batched mesh
			const batchedMesh = new BatchedMesh( 4, 5000, 10000, material );
			const boxGeometryId = batchedMesh.addGeometry( box );
			
			// create instances of this geometry
			let boxInstanceIds = [];
			for (let i = 0; i < 4; i++){
				boxInstanceIds.push( batchedMesh.addInstance( boxGeometryId ) );
			}
			
			batchedMesh.deleteInstance( boxInstanceIds[2] );
			batchedMesh.deleteInstance( boxInstanceIds[3] );

			// shrink the instance count
			batchedMesh.setInstanceCount(2);

			assert.ok( batchedMesh.instanceCount === 2, 'instance count unequal 2' );

		} );

	} );

} );
